//	CCopyFile_FsSpec.h

#ifndef _H_CCopyFile_FsSpec
#define	_H_CCopyFile_FsSpec

#include "CCopyFile.h"

class	CCopyFile_FsSpec : public CCopyFile {
	
	public: OSErr	ICopyFile_FsSpec(
		CCopyFile		*parent0, 
		Ptr				myData);
		
	virtual	void	Dispose(void);
	virtual	void	LogCopyFileType(void);

	FSSpec			*GetFSSpec(void);
	virtual	OSErr	GetFileInfo(CCT_MemFileRec *fileRecP);
	virtual	OSErr	SetFileInfo(CCT_MemFileRec *fileRecP);
	
	virtual	OSErr	IsFolder(Boolean *isFolderB);
	virtual	OSErr	CountFilesInFolder(ulong *numFilesL);
	virtual	OSErr	GetIndFileInFolder(ulong fileIndex, Ptr *fileDataP);

	virtual	OSErr	CreateFile(Ptr parentFolderP, CCT_MemFileRec *fileRecP);
	virtual	OSErr	Delete(void);
	virtual	void	DisposeData(void);
	
	virtual	OSErr	Open(ADFS_IOType ioType, Boolean resForkB);
	virtual	OSErr	Close(void);

	virtual	OSErr	Read(ulong *bytesIO, char *bufP);
	virtual	OSErr	Write(ulong *bytesIO, char *bufP);
	
	virtual	OSErr	VerifyFreeSpace(CCT_CopyRec *copyRecP);
	virtual	OSErr	VerifyFileSize(CCopyFile *sourceP, ulong fileSizeL);
	virtual	OSErr	GetSizeSelf(CCT_CopyRec *copyRecP);

	virtual	OSErr	ScanForCopySelf(Ptr myDataP, CCopyFile **fileExistsH);

	virtual	OSErr	GetParentRef(Ptr *parentFolderH);
	virtual	OSErr	GetVolumeRef(Ptr *volumeH);

	virtual	Boolean	IsForked(void);
	virtual	Boolean	SupportsForks(void);
	virtual	OSErr	GetForkInfo(CCT_ForkInfo *forkInfoP);
	virtual	OSErr	SetForkInfo(CCT_ForkInfo *forkInfoP);

	/********************************************/
	short		i_fileRefNum;
	
	//	ONLY used for iterating over a folder's contents
	FSSpec		i_indFileSpec;
	
	//	ONLY used for GetParentRef or GetVolumeRef
	FSSpec		i_parentFileSpec;
	
	typedef		CCopyFile		_inherited;
};

#endif